<?php 
require_once('connection/dbConfig.php');
require_once('include/functions.inc.php');
require_once('Spreadsheet/Excel/Writer.php');

header('Content-Language: en');
header('Content-Type: text/html;charset=UTF-8');


session_start();
if($_SESSION['name'] == ""){
	header("location:./login.php");
}
set_time_limit(0);

//Creating a workbook
$workbook = new Spreadsheet_Excel_Writer();
$workbook->setVersion(8);
//Sending HTTP headers
$workbook->send('certificates.xls');
 
//Creating a worksheet
$worksheet=&$workbook->addWorksheet('Certificates List');
$worksheet->setLandscape();
 

 
//set all columns same width
$columnWidth = 10;

//Title Format 
$sheetTitleFormat =& $workbook->addFormat(array('bold'=>1,
  'size'=>10));

//Column Title Format  
$columnTitleFormat =& $workbook->addFormat(array('bold'=>1,
  'top'=>1,
  'bottom'=>1 ,
  'size'=>15,
  'color'=>0x0A,
  ));
  
 
  
// Regular Format
$regularleftFormat =& $workbook->addFormat(array('size'=>11,
  'align'=>'left'  ));
$regularleftFormat->setTextWrap();
$regularrightFormat =& $workbook->addFormat(array('size'=>11,
  'align'=>'right'  ));  
$regularrightFormat->setTextWrap();
  
$TitleFormat =& $workbook->addFormat(array('size'=>14,
  'align'=>'left',
  'bold'=>1
  ));
$TitleFormatCenter =& $workbook->addFormat(array('size'=>14,
  'align'=>'center',
  'bold'=>1
  )); 
$TitleFormatright =& $workbook->addFormat(array('size'=>14,
  'align'=>'right',
  'bold'=>1
  ));   

$boldleftFormat =& $workbook->addFormat(array('size'=>11,
  'align'=>'left'  ,
  'valign'=>'top'  ,
  'bold'=>1
  ));  
$boldrightFormat =& $workbook->addFormat(array('size'=>11,
  'align'=>'right'  ,
  'valign'=>'top'  ,
  'bold'=>1
  )); 
$boldcenterFormat =& $workbook->addFormat(array('size'=>11,
  'align'=>'center'  ,
  'valign'=>'top'  ,
  'bold'=>1
  ));    
  

	if (empty($_GET['txtfromdate'])) {
		$txtfromdate	= displayToday();
	} else {
		$txtfromdate	= $_GET['txtfromdate'];
	}
	if (empty($_GET['txttodate'])) {
		$txttodate	= displayToday();
	} else {
		$txttodate	= $_GET['txttodate'];
	}

	$worksheet->setInputEncoding('utf-8');

	//Display Report Header
	$worksheet->write(0,1,"لائحة الاستمارات", $TitleFormatCenter);
	$worksheet->write(1,1,"تاريخ: " . $txtfromdate . " - " . $txttodate, $TitleFormatCenter);
	$worksheet->setColumn (0, 0, 40);
	$worksheet->setColumn (1, 1, 80);
	$worksheet->setColumn (2, 2, 20);
	$worksheet->setColumn (3, 3, 20);
		
	
	$RowNum    = 4;
	$ColumnNum = 3;	
	
	$worksheet->write($RowNum,$ColumnNum,"الرقم الاّلي", $boldrightFormat);
	$ColumnNum -= 1;
	$worksheet->write($RowNum,$ColumnNum,"الرقم المالي", $boldrightFormat);
	$ColumnNum -= 1;
	$worksheet->write($RowNum,$ColumnNum,"الاسم الثلاثي", $boldrightFormat);
	$ColumnNum -= 1;
	$worksheet->write($RowNum,$ColumnNum,"المنطقة التربوية", $boldrightFormat);
	$ColumnNum -= 1;
	
	$RowNum    = 5;
	$ColumnNum = 3;

	$query = 	" SELECT proctors.proctorid, autonum, fno, name, d.area_description, g.mouha_name as proctor_mouha, h.caza_description as proctor_caza,  ".
				" b.subject_description as sec_subject, c.subject_description as prim_subject ".
				" FROM proctors ". 
				" INNER JOIN proctor_details on proctor_details.proctorid = proctors.proctorid ".
				" LEFT JOIN subjects b on proctor_details.sec_subject_id = b.subject_id and b.subject_type = 'SEC' ".
				" LEFT JOIN subjects c on proctor_details.prim_subject_id = c.subject_id and c.subject_type = 'PRI' ".
				" LEFT JOIN areas d on proctors.area_id = d.area_id ".
				" LEFT JOIN mouha g on proctors.mouha_id = g.mouha_id ".
				" LEFT JOIN caza h on proctors.caza_id = h.caza_id ".
				" WHERE date_format(proctor_details.detaildate,'%Y-%m-%d') between date_format(?,'%Y-%m-%d') and date_format(?,'%Y-%m-%d') ";

	//echo $query;
	$stmt = $connAdmin->prepare($query);
	$stmt->bindValue(1, insertMySQLDate($txtfromdate), PDO::PARAM_STR);
	$stmt->bindValue(2, insertMySQLDate($txttodate), PDO::PARAM_STR);

	try {
		$stmt->execute();
		while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
			
			$worksheet->write($RowNum,$ColumnNum,$row['autonum'], $regularrightFormat);
			$ColumnNum -= 1;
			$worksheet->write($RowNum,$ColumnNum,$row['fno'], $regularrightFormat);
			$ColumnNum -= 1;
			$worksheet->write($RowNum,$ColumnNum,$row['name'], $regularrightFormat);
			$ColumnNum -= 1;
			$worksheet->write($RowNum,$ColumnNum,$row['area_description'], $regularrightFormat);
			$ColumnNum -= 1;
			
			$RowNum += 1;
			$ColumnNum = 3;
		}
		
	} catch(PDOException $ex) {
		$error_msg  = $ex->getMessage();
		echo $error_msg;
	}

$workbook->close();

?>